

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/about.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('title', 'About Cee Horizon | Trusted Engineering Services in Nigeria'); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="Cee Horizon is a trusted engineering services company based in Owerri, Imo State, providing professional solar installations, electrical wiring, CCTV systems, and satellite TV services across Nigeria.">
<meta name="keywords" content="About Cee Horizon, engineering services Nigeria, solar installations Owerri, electrical wiring, CCTV installation, satellite TV services, Imo State, Nigeria">
<meta name="robots" content="index, follow">

<!-- Open Graph / Facebook & WhatsApp -->
<meta property="og:title" content="About Cee Horizon | Trusted Engineering Services in Nigeria">
<meta property="og:description" content="Learn about Cee Horizon, a professional engineering services company delivering reliable solar, electrical, CCTV, and satellite TV solutions across Nigeria.">
<meta property="og:type" content="website">
<meta property="og:url" content="<?php echo e(url()->current()); ?>">
<meta property="og:image" content="<?php echo e(asset('images/company-intro.jpg')); ?>">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="About Cee Horizon | Trusted Engineering Services in Nigeria">
<meta name="twitter:description" content="Cee Horizon delivers professional solar, electrical, CCTV, and satellite TV engineering services in Owerri and across Nigeria.">
<meta name="twitter:image" content="<?php echo e(asset('images/company-intro.jpg')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

<!-- ABOUT PAGE HERO -->
<section class="hero-section hero-inner position-relative">
    <!-- Hero Image -->
    <img 
        src="<?php echo e(asset('images/about-hero.webp')); ?>"
        alt="About Cee Horizon – professional Nigerian solar and electrical installation team"
        loading="eager"
        fetchpriority="high"
        class="hero-img"
    />

    <!-- Dark overlay for readability -->
    <div class="hero-overlay"></div>

    <div class="container">
        <div class="row">
            <div class="col-lg-7 hero-content">
                <h1 class="fw-bold display-3 hero-title">
                    About Cee Horizon
                </h1>
                <p class="lead mt-3 hero-text">
                    Professional solar, electrical, CCTV, and satellite TV solutions engineered for safety, efficiency, and long-term reliability.
                </p>
            </div>
        </div>
    </div>
</section>


<!-- COMPANY OVERVIEW -->
<section class="about-section overview reveal">
    <div class="container">
        <div class="row align-items-center g-5">

            <div class="col-lg-6">
                <span class="section-tag">WHO WE ARE</span>
                <h2 class="section-title text-primary">
                    Trusted Engineering Services in Owerri, Serving Clients Across Nigeria
                </h2>

                <p class="mt-3">
                    Cee Horizon is a professional engineering services company based in <strong>Owerri, Imo State</strong>, specializing in solar power installations, CCTV security systems, satellite TV installations, and complete electrical wiring solutions.
                </p>

                <p>
                    While proudly rooted in Owerri, our team delivers reliable engineering solutions to homes, businesses, and commercial projects <strong>anywhere in Nigeria</strong>.
                </p>

                <p>
                    Our work is driven by technical expertise, strict safety standards, and a commitment to delivering systems that perform reliably in real-world conditions.
                </p>
            </div>

            <div class="col-lg-6">
                <div class="image-frame">
                    <img 
                        src="<?php echo e(asset('images/about-company.webp')); ?>"
                        class="img-fluid"
                        alt="Cee Horizon engineering team at a residential solar and CCTV installation site in Owerri Nigeria"
                        >
                </div>
            </div>

        </div>
    </div>
</section>

<!-- CORE VALUES -->
<section class="about-section core-values bg-light">
    <div class="container">
        <div class="text-center mb-5">
            <span class="section-tag">OUR VALUES</span>
            <h2 class="section-title text-primary">What Drives Our Engineering Work</h2>
        </div>

        <div class="row g-4 reveal reveal-stagger">

            <div class="col-md-6 col-lg-3">
                <div class="value-card">
                    <i class="bi bi-shield-check"></i>
                    <h5>Safety First</h5>
                    <p>Every solar, electrical, and CCTV project is executed with strict safety compliance.</p>
                </div>
            </div>

            <div class="col-md-6 col-lg-3">
                <div class="value-card">
                    <i class="bi bi-award"></i>
                    <h5>Quality Work</h5>
                    <p>We use industry-approved materials and proven installation practices.</p>
                </div>
            </div>

            <div class="col-md-6 col-lg-3">
                <div class="value-card">
                    <i class="bi bi-people"></i>
                    <h5>Customer Focus</h5>
                    <p>Solutions tailored to client needs, timelines, and budgets.</p>
                </div>
            </div>

            <div class="col-md-6 col-lg-3">
                <div class="value-card">
                    <i class="bi bi-gear"></i>
                    <h5>Technical Expertise</h5>
                    <p>Experienced technicians delivering reliable engineering solutions nationwide.</p>
                </div>
            </div>

        </div>
    </div>
</section>

<!-- WHY US -->
<section class="about-section why-us reveal">
    <div class="container">
        <div class="why-us-card">
            <div class="row align-items-center g-0">

                <div class="col-lg-6">
                    <div class="why-image">
                        <img 
                            src="<?php echo e(asset('images/why-choose-cee-horizon.webp')); ?>"
                            alt="Cee Horizon technicians installing and inspecting a solar inverter and electrical system in a Nigerian home"
                            >
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="why-content">
                        <span class="section-tag">WHY CHOOSE US</span>
                        <h2 class="section-title text-primary">
                            Engineered for Reliability and Long-Term Performance
                        </h2>

                        <p class="mt-3">
                            We don’t just install systems — we engineer dependable solutions designed to perform efficiently over time.
                        </p>

                        <ul class="why-list mt-4">
                            <li><i class="bi bi-check-circle-fill"></i> Skilled and certified technicians</li>
                            <li><i class="bi bi-check-circle-fill"></i> Industry-grade materials</li>
                            <li><i class="bi bi-check-circle-fill"></i> Transparent pricing</li>
                            <li><i class="bi bi-check-circle-fill"></i> Reliable post-installation support</li>
                        </ul>
                    </div>
                </div>

            </div>
        </div>
    </div>
</section>

<!-- CTA -->
<section class="about-section cta-section reveal">
    <div class="container text-center">
        <h2 class="fw-bold text-white">
            Let’s Build Something Reliable Together
        </h2>
        <p class="text-light mt-2">
            Contact Cee Horizon for professional solar, electrical, CCTV, or satellite TV services anywhere in Nigeria.
        </p>
        <a href="<?php echo e(route('contact')); ?>" class="btn btn-accent btn-lg mt-3">
            Get in Touch
        </a>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\SOOQ ELASER\Desktop\web-projects\horizon\resources\views\pages\about.blade.php ENDPATH**/ ?>