

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/contact.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('title', 'Contact Cee Horizon | Solar, CCTV & Electrical Services in Nigeria'); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="Contact Cee Horizon for professional solar installations, electrical wiring, CCTV systems, and satellite TV services across Nigeria. Based in Owerri, Imo State, serving homes and businesses nationwide.">
<meta name="keywords" content="Contact Cee Horizon, solar installation Nigeria, electrical services Owerri, CCTV installation, satellite TV services, engineering services Nigeria">
<meta name="robots" content="index, follow">

<!-- Open Graph / Facebook & WhatsApp -->
<meta property="og:title" content="Contact Cee Horizon | Solar, CCTV & Electrical Services in Nigeria">
<meta property="og:description" content="Get in touch with Cee Horizon for expert solar, electrical, CCTV, and satellite TV services in Owerri and across Nigeria.">
<meta property="og:type" content="website">
<meta property="og:url" content="<?php echo e(url()->current()); ?>">
<meta property="og:image" content="<?php echo e(asset('images/company-intro.jpg')); ?>">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Contact Cee Horizon | Solar, CCTV & Electrical Services in Nigeria">
<meta name="twitter:description" content="Reach out to Cee Horizon for reliable solar, electrical, CCTV, and satellite TV installations anywhere in Nigeria.">
<meta name="twitter:image" content="<?php echo e(asset('images/company-intro.jpg')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php
    $selectedService = request('service');
?>

<!-- CONTACT PAGE HERO -->
<section class="hero-section hero-inner position-relative">
    <!-- Hero Image -->
    <img 
        src="<?php echo e(asset('images/contact-hero.webp')); ?>"
        alt="Friendly Nigerian technicians ready to provide solar, CCTV and electrical installation services at Cee Horizon"
        loading="eager"
        fetchpriority="high"
        class="hero-img"
    />


    <!-- Dark overlay for readability -->
    <div class="hero-overlay"></div>

    <div class="container">
        <div class="row">
            <div class="col-lg-7 hero-content">
                <h1 class="fw-bold display-3 hero-title">
                    Get in Touch
                </h1>
                <p class="lead mt-3 hero-text">
                    Have a project in mind or need professional installation services?
                    We’re here to help.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- CONTACT SECTION -->
<section class="contact-section">
    <div class="container">
        <div class="row g-5 align-items-stretch reveal reveal-stagger">

            <!-- CONTACT INFO -->
            <div class="col-lg-5">
                <div class="contact-info h-100">
                    <span class="section-tag">CONTACT</span>
                    <h2 class="section-title mb-4">
                        Let’s Talk About Your Project
                    </h2>

                    <ul class="contact-list">
                        <li>
                            <i class="bi bi-geo-alt-fill"></i>
                            <span> No. 9 Reservoir Road, Ohii Junction Owerri-Orlu Road Imo State, Nigeria</span>
                        </li>
                        <li>
                            <i class="bi bi-telephone-fill"></i>
                            <span>
                                <a href="tel:+2348064602438">+234 806 460 2438</a>
                            </span>
                        </li>
                        <li>
                            <i class="bi bi-envelope-fill"></i>
                            <span>
                                <a href="mailto:info@ceehorizon.com">info@ceehorizon.com</a>
                            </span>
                        </li>
                        <li>
                            <i class="bi bi-clock-fill"></i>
                            <span>Mon – Sat: 8:00am – 6:00pm</span>
                        </li>
                    </ul>

                    <div class="contact-socials mt-4">
                        <a href="#"><i class="bi bi-facebook"></i></a>
                        <a href="#"><i class="bi bi-whatsapp"></i></a>
                        <a href="#"><i class="bi bi-instagram"></i></a>
                        <a href="#"><i class="bi bi-linkedin"></i></a>
                    </div>
                </div>
            </div>

            <!-- CONTACT FORM -->
            <div class="col-lg-7">
                <div class="contact-form-wrapper h-100">

                    
                    <?php if($selectedService): ?>
                        <div class="selected-service mb-4">
                            <span>Selected Service:</span>
                            <strong><?php echo e($selectedService); ?></strong>
                        </div>
                    <?php endif; ?>

                    
                    <?php if(session('success')): ?>
                        <div class="alert alert-success mb-4">
                            <?php echo e(session('success')); ?>

                        </div>
                    <?php endif; ?>

                    
                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger mb-4">
                            <ul class="mb-0">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    <form class="contact-form" method="POST" action="<?php echo e(route('contact.submit')); ?>">
                        <?php echo csrf_field(); ?>

                        
                        <input type="text" name="company_website" style="display:none">

                        
                        <input type="hidden" name="service" value="<?php echo e($selectedService); ?>">

                        <div class="row g-4">
                            <div class="col-md-6">
                                <div class="input-group">
                                    <input type="text" name="name" class="form-control" required>
                                    <label>Your Name</label>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <div class="input-group">
                                    <input type="email" name="email" class="form-control" required>
                                    <label>Email Address</label>
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="input-group">
                                    <input
                                        type="text"
                                        name="subject"
                                        class="form-control"
                                        value="<?php echo e($selectedService ? 'Service Request: ' . $selectedService : ''); ?>"
                                        required
                                    >
                                    <label>Subject</label>
                                </div>
                            </div>

                            <div class="col-12">
                                <div class="input-group">
                                    <textarea name="body" rows="5" class="form-control" required></textarea>
                                    <label>Your Message</label>
                                </div>
                            </div>

                            <div class="col-12">
                                <button type="submit" class="btn btn-primary w-100" id="contactSubmitBtn">
                                    <span class="btn-text">Send Message</span>
                                    <span class="spinner-border spinner-border-sm d-none" id="contactSpinner"></span>
                                </button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>

        </div>
    </div>
</section>

<!-- MAP SECTION -->
<section class="map-section reveal">
    <iframe
        src="https://www.google.com/maps/embed?pb=!1m14!1m12!1m3!1d3971.1869012492366!2d7.01365012973098!3d5.539278311384315!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!5e0!3m2!1sen!2sng!4v1767967418599!5m2!1sen!2sng"
        allowfullscreen
        loading="lazy"
        referrerpolicy="no-referrer-when-downgrade">
    </iframe>
</section>

<!-- CTA -->
<section class="cta-section text-center text-white reveal">
    <div class="container py-5">
        <h2 class="mb-3">Need Immediate Assistance?</h2>
        <p class="mb-4">Call us today and let our experts guide you.</p>
        <a href="tel:+2348000000000" class="btn btn-accent btn-lg">Call Now</a>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
    const form = document.querySelector('.contact-form');
    const submitBtn = document.getElementById('contactSubmitBtn');
    const spinner = document.getElementById('contactSpinner');

    if (!form) return;

    form.addEventListener('submit', function () {
        submitBtn.disabled = true;
        spinner.classList.remove('d-none');
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\SOOQ ELASER\Desktop\web-projects\horizon\resources\views\pages\contact.blade.php ENDPATH**/ ?>