<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">

    
    <title><?php echo $__env->yieldContent('title', 'Engineering Services in Nigeria'); ?> | Cee Horizon</title>

    <!-- FAVICONS -->
    <link rel="icon" type="image/x-icon" href="<?php echo e(asset('favicons/favicon.ico')); ?>">
    <link rel="icon" type="image/png" sizes="32x32" href="<?php echo e(asset('favicons/favicon-32x32.png')); ?>">
    <link rel="icon" type="image/png" sizes="16x16" href="<?php echo e(asset('favicons/favicon-16x16.png')); ?>">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo e(asset('favicons/apple-touch-icon.png')); ?>">
    <link rel="manifest" href="<?php echo e(asset('favicons/site.webmanifest')); ?>">

    <meta name="theme-color" content="#0d6efd">


    
    <?php echo $__env->yieldContent('meta'); ?>

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons/font/bootstrap-icons.css" rel="stylesheet">

    <!-- Global Styles -->
    <link rel="stylesheet" href="<?php echo e(asset('css/app.css')); ?>">

    
    <?php echo $__env->yieldPushContent('styles'); ?>
</head>
<body>

    
    <div id="page-preloader">
        <div class="spinner"></div>
    </div>

    
    <?php echo $__env->make('partials.navbar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <main>
        <?php echo $__env->yieldContent('content'); ?>
    </main>

    
    <?php echo $__env->make('partials.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <!-- WhatsApp Floating Button -->
    <a href="https://wa.me/2348167481877"
       class="whatsapp-float"
       target="_blank"
       aria-label="Chat with us on WhatsApp">
       <i class="bi bi-whatsapp"></i>
    </a>

    <!-- Bootstrap JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Unified Custom JS -->
    <script src="<?php echo e(asset('js/main.js')); ?>"></script>

    
    <?php echo $__env->yieldContent('scripts'); ?>
</body>
</html>
<?php /**PATH C:\Users\SOOQ ELASER\Desktop\web-projects\horizon\resources\views\layouts\app.blade.php ENDPATH**/ ?>