

<?php $__env->startPush('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('css/home.css')); ?>">
<?php $__env->stopPush(); ?>

<?php $__env->startSection('title', 'Solar, CCTV & Electrical Engineering Services in Nigeria'); ?>

<?php $__env->startSection('meta'); ?>
<meta name="description" content="Cee Horizon offers professional solar, electrical, CCTV, and satellite TV solutions across Nigeria. Based in Owerri, we provide reliable installations, maintenance, and energy solutions for homes and businesses.">
<meta name="keywords" content="Cee Horizon, solar installation Nigeria, electrical wiring, CCTV installation, satellite TV, Owerri, Nigeria, energy solutions">
<meta name="robots" content="index, follow">

<!-- Open Graph / Facebook & WhatsApp -->
<meta property="og:title" content="Solar, CCTV & Electrical Engineering Services in Nigeria | Cee Horizon">
<meta property="og:description" content="Professional solar, electrical, CCTV and satellite TV installations across Nigeria. Trusted engineering services by Cee Horizon.">
<meta property="og:type" content="website">
<meta property="og:url" content="<?php echo e(url()->current()); ?>">
<meta property="og:image" content="<?php echo e(asset('images/company-intro.jpg')); ?>">

<!-- Twitter Card -->
<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="Solar, CCTV & Electrical Engineering Services in Nigeria | Cee Horizon">
<meta name="twitter:description" content="Professional solar, electrical, CCTV and satellite TV installations across Nigeria by Cee Horizon.">
<meta name="twitter:image" content="<?php echo e(asset('images/company-intro.jpg')); ?>">
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>

<!-- HERO SECTION -->
<section class="hero-section position-relative">
    <!-- Hero Image -->
    <img 
        src="<?php echo e(asset('images/solar-hero.webp')); ?>"
        alt="Professional solar panel installation at a residential home in Nigeria by Cee Horizon"
        loading="eager"
        class="hero-img"
    >

    <!-- Dark overlay (replaces CSS background gradient) -->
    <div class="hero-overlay"></div>

    <div class="container">
        <div class="row">
            <div class="col-lg-7 hero-content">
                <h1 class="fw-bold display-3 hero-title">
                    Reliable Electrical & Solar Solutions
                </h1>

                <p class="lead mt-4 hero-text">
                    Cee Horizon provides professional solar & inverter installations,
                    CCTV camera setup, satellite TV installations, and complete house
                    electrical wiring with guaranteed quality and safety.
                </p>

                <div class="mt-4 hero-actions">
                    <a href="<?php echo e(route('contact')); ?>" class="btn btn-primary btn-lg me-3">
                        Request a Quote
                    </a>
                    <a href="<?php echo e(route('services')); ?>" class="btn btn-outline-light btn-lg">
                        Our Services
                    </a>
                </div>
            </div>
        </div>
    </div>
</section>


<!-- COMPANY INTRODUCTION SECTION -->
<section class="company-intro reveal">
    <div class="container">
        <div class="row align-items-stretch">

            <div class="col-lg-5 mb-4 mb-lg-0 d-flex align-items-stretch">
                <img 
                    src="<?php echo e(asset('images/cctv-installation.webp')); ?>" 
                    alt="Professional CCTV camera installation at a residential home in Nigeria by Cee Horizon"
                    loading="lazy" 
                    class="img-fluid rounded shadow flex-fill"
                >
            </div>

            <div class="col-lg-7 py-lg-4 text-column">
                <h2 class="fw-bold text-primary mb-3">About Cee Horizon</h2>
                <p class="lead">
                    Cee Horizon is your trusted partner for all electrical and energy solutions. 
                    We specialize in solar and inverter installations, CCTV camera setup, satellite TV installations, 
                    and complete house electrical wiring and maintenance. Our team combines experience, professionalism, 
                    and quality workmanship to ensure your home or business is safe, efficient, and powered reliably.
                </p>

                <div class="key-points">
                    <div class="d-flex align-items-center gap-3">
                        <i class="bi bi-award"></i>
                        <div>
                            <h5 class="fw-semibold mb-1">Experience</h5>
                            <p class="mb-0">Years of professional electrical & solar service experience.</p>
                        </div>
                    </div>
                    <div class="d-flex align-items-center gap-3">
                        <i class="bi bi-check-circle"></i>
                        <div>
                            <h5 class="fw-semibold mb-1">Quality Work</h5>
                            <p class="mb-0">High-quality installations and maintenance you can trust.</p>
                        </div>
                    </div>
                    <div class="d-flex align-items-center gap-3">
                        <i class="bi bi-shield-lock"></i>
                        <div>
                            <h5 class="fw-semibold mb-1">Safety & Reliability</h5>
                            <p class="mb-0">Safe electrical solutions that ensure reliable performance.</p>
                        </div>
                    </div>
                </div>

                <a href="<?php echo e(route('services')); ?>" class="btn btn-learn-more">
                    Learn More
                </a>

            </div>
        </div>
    </div>
</section>

<!-- SERVICES OVERVIEW SECTION -->
<section class="services-overview reveal">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold text-primary">Our Services</h2>
            <p class="lead mx-auto" style="max-width: 700px;">
                Cee Horizon offers a wide range of professional services to keep your home or business safe, efficient, and powered reliably.
            </p>
        </div>

        <div class="row g-4 reveal reveal-stagger">
            <!-- Service 1 -->
            <div class="col-md-6 col-lg-3">
                <div class="card h-100 shadow-sm service-card text-center overflow-hidden">
                    <img src="<?php echo e(asset('images/solar-card.webp')); ?>" alt="Solar panel and inverter installation at a residential home in Nigeria by Cee Horizon" class="card-img-top service-img">
                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title fw-semibold text-primary">Solar & Inverter Installations</h5>
                        <p class="card-text">Professional solar panel and inverter installations to power your home or business efficiently.</p>
                        <a href="<?php echo e(route('contact', ['service' => 'Solar & Inverter Installation'])); ?>" class="btn btn-primary mt-auto">Request Service</a>
                    </div>
                </div>
            </div>

            <!-- Service 2 -->
            <div class="col-md-6 col-lg-3">
                <div class="card h-100 shadow-sm service-card text-center overflow-hidden">
                    <img src="<?php echo e(asset('images/cctv-card.webp')); ?>" alt="CCTV camera installation at a residential home in Nigeria by Cee Horizon" class="card-img-top service-img">
                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title fw-semibold text-primary">CCTV Camera Installations</h5>
                        <p class="card-text">Secure your property with high-quality CCTV installations and monitoring solutions.</p>
                        <a href="<?php echo e(route('contact', ['service' => 'CCTV Camera Installation'])); ?>" class="btn btn-primary mt-auto">Request Service</a>
                    </div>
                </div>
            </div>

            <!-- Service 3 -->
            <div class="col-md-6 col-lg-3">
                <div class="card h-100 shadow-sm service-card text-center overflow-hidden">
                    <img src="<?php echo e(asset('images/satellite-card.webp')); ?>" alt="Satellite TV dish installation at a Nigerian home by Cee Horizon" class="card-img-top service-img">
                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title fw-semibold text-primary">Satellite TV Installations</h5>
                        <p class="card-text">Enjoy uninterrupted entertainment with professional satellite TV setup for your home or office.</p>
                        <a href="<?php echo e(route('contact', ['service' => 'Satellite TV Installation'])); ?>" class="btn btn-primary mt-auto">Request Service</a>
                    </div>
                </div>
            </div>

            <!-- Service 4 -->
            <div class="col-md-6 col-lg-3">
                <div class="card h-100 shadow-sm service-card text-center overflow-hidden">
                    <img src="<?php echo e(asset('images/electrical-card.webp')); ?>" alt="Professional electrical wiring and maintenance at a Nigerian home by Cee Horizon" class="card-img-top service-img">
                    <div class="card-body d-flex flex-column">
                        <h5 class="card-title fw-semibold text-primary">Electrical Wiring & Maintenance</h5>
                        <p class="card-text">Complete house wiring, repairs, and maintenance to ensure safe and reliable electricity.</p>
                        <a href="<?php echo e(route('contact', ['service' => 'Electrical Wiring & Maintenance'])); ?>" class="btn btn-primary mt-auto">Request Service</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- WHY CHOOSE US SECTION -->
<section class="why-choose-us reveal">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold text-primary">Why Choose Cee Horizon?</h2>
            <p class="lead mx-auto" style="max-width: 700px;">
                We combine experience, quality, reliability, and a strong warranty policy to deliver electrical and solar solutions you can trust anywhere in Nigeria.
            </p>
        </div>

        <div class="row g-4 text-center reveal reveal-stagger">
            <div class="col-md-6 col-lg-3">
                <div class="choose-card p-4 h-100 shadow-sm">
                    <i class="bi bi-award display-4 text-primary mb-3"></i>
                    <h5 class="fw-semibold mb-2">Experience</h5>
                    <p>Years of hands-on experience in electrical and solar installations.</p>
                </div>
            </div>

            <div class="col-md-6 col-lg-3">
                <div class="choose-card p-4 h-100 shadow-sm">
                    <i class="bi bi-check-circle display-4 text-primary mb-3"></i>
                    <h5 class="fw-semibold mb-2">Reliability</h5>
                    <p>Consistent, dependable service for homes and businesses.</p>
                </div>
            </div>

            <div class="col-md-6 col-lg-3">
                <div class="choose-card p-4 h-100 shadow-sm">
                    <i class="bi bi-star display-4 text-primary mb-3"></i>
                    <h5 class="fw-semibold mb-2">Quality</h5>
                    <p>High-quality workmanship with attention to detail on every project.</p>
                </div>
            </div>

            <div class="col-md-6 col-lg-3">
                <div class="choose-card p-4 h-100 shadow-sm">
                    <i class="bi bi-shield-lock display-4 text-primary mb-3"></i>
                    <h5 class="fw-semibold mb-2">Warranty</h5>
                    <p>Strong warranty and support on all installations and services.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- COMPLETED PROJECTS SECTION -->
<section class="projects-section reveal">
    <div class="container">
        <div class="text-center mb-5">
            <h2 class="fw-bold text-primary">Our Completed Projects</h2>
            <p class="text-muted mt-2">
                A glimpse of some of the solar, electrical, CCTV, and satellite TV installations we’ve successfully delivered.
            </p>
        </div>

        <div class="row g-4 reveal reveal-stagger">
            <div class="col-md-4">
                <div class="project-card">
                    <img src="<?php echo e(asset('images/project-solar.webp')); ?>" alt="Completed residential solar installation in Nigeria by Cee Horizon">
                    <div class="project-info">
                        <h6>Solar Installation</h6>
                        <span>Residential Project</span>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="project-card">
                    <img src="<?php echo e(asset('images/project-cctv.webp')); ?>" alt="Professional CCTV camera installation in Nigeria by Cee Horizon">
                    <div class="project-info">
                        <h6>CCTV Camera Setup</h6>
                        <span>Office Security</span>
                    </div>
                </div>
            </div>

            <div class="col-md-4">
                <div class="project-card">
                    <img src="<?php echo e(asset('images/project-electrical.webp')); ?>" alt="Completed electrical wiring project in a Nigerian home by Cee Horizon">
                    <div class="project-info">
                        <h6>Electrical Wiring</h6>
                        <span>Complete Building</span>
                    </div>
                </div>
            </div>
        </div>

        <div class="text-center mt-4">
            <a href="<?php echo e(route('projects')); ?>" class="btn btn-primary btn-lg">
                View All Projects
            </a>
        </div>
    </div>
</section>

<!-- CALL-TO-ACTION BANNER -->
<section class="cta-banner text-center text-white reveal">
    <div class="container">
        <h2 class="fw-bold mb-3 cta-title">
            Ready to Power Your Home or Business?
        </h2>

        <p class="lead mb-4 cta-text">
            Contact Cee Horizon today for professional solar, electrical, CCTV, or satellite TV services across Nigeria. Reliable solutions, guaranteed quality.
        </p>

        <a href="<?php echo e(route('contact')); ?>" class="btn btn-light btn-lg cta-btn">
            Request a Quote
        </a>
    </div>
</section>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\SOOQ ELASER\Desktop\web-projects\horizon\resources\views\pages\home.blade.php ENDPATH**/ ?>