<footer class="footer bg-dark text-light pt-5 position-relative">
    <div class="container">
        <!-- Row with horizontal spacing -->
        <div class="row gy-4 gx-5 reveal reveal-stagger">

            <!-- About Column -->
            <div class="col-md-4 pe-md-4">
                <h3 class="fw-bold text-white mb-3">
                    <span class="brand-accent">Cee</span> Horizon
                </h3>
                <p>
                    Professional electrical and solar solutions. We provide reliable solar installations,
                    CCTV setup, satellite TV installations, and complete house electrical wiring & maintenance.
                </p>
            </div>

            <!-- Services Column -->
            <div class="col-md-3">
                <h5 class="fw-bold text-white mb-3">Our Services</h5>
                <ul class="list-unstyled">
                    <li class="mb-2">
                        <a href="{{ route('services') }}#solar" class="footer-link">
                            Solar & Inverter Installations
                        </a>
                    </li>
                    <li class="mb-2">
                        <a href="{{ route('services') }}#cctv" class="footer-link">
                            CCTV Camera Installations
                        </a>
                    </li>
                    <li class="mb-2">
                        <a href="{{ route('services') }}#satellite" class="footer-link">
                            Satellite TV Installations
                        </a>
                    </li>
                    <li class="mb-2">
                        <a href="{{ route('services') }}#electrical" class="footer-link">
                            Electrical Wiring & Maintenance
                        </a>
                    </li>
                </ul>
            </div>

            <!-- Quick Links Column -->
            <div class="col-md-2">
                <h5 class="fw-bold text-white mb-3">Quick Links</h5>
                <ul class="list-unstyled">
                    <li class="mb-2">
                        <a href="{{ route('home') }}" class="footer-link">Home</a>
                    </li>
                    <li class="mb-2">
                        <a href="{{ route('about') }}" class="footer-link">About</a>
                    </li>
                    <li class="mb-2">
                        <a href="{{ route('services') }}" class="footer-link">Services</a>
                    </li>
                    <li class="mb-2">
                        <a href="{{ route('contact') }}" class="footer-link">Contact</a>
                    </li>
                </ul>
            </div>

            <!-- Contact Column -->
            <div class="col-md-3">
                <h5 class="fw-bold text-white mb-3">Contact Us</h5>

                <p class="mb-2">
                    <i class="bi bi-telephone me-2"></i>
                    <a href="tel:+2348001234567" class="footer-link contact-item">
                        +234 800 123 4567
                    </a>
                </p>

                <p class="mb-2">
                    <i class="bi bi-envelope me-2"></i>
                    <a href="mailto:info@horizoncee.com" class="footer-link contact-item">
                        info@ceehorizon.com
                    </a>
                </p>

                <p>
                    <i class="bi bi-geo-alt me-2"></i>
                    <span class="contact-item">No. 9 Reservoir Road, Ohii Junction off Owerri-Orlu Road Imo State, Nigeria</span>
                </p>

                <div class="mt-3 social-icons">
                    <a href="https://www.facebook.com/share/1DDHNm227x/"><i class="bi bi-facebook"></i></a>
                    <a href="https://x.com/CEEhorizon"><i class="bi bi-twitter"></i></a>
                    <a href="https://www.instagram.com/ceehorizon?utm_source=qr&igsh=dmcxOWl4bGZwaTZ1"><i class="bi bi-instagram"></i></a>
                    <a href="https://www.linkedin.com/in/cee-horizon-b59705260?utm_source=share&utm_campaign=share_via&utm_content=profile&utm_medium=android_app"><i class="bi bi-linkedin"></i></a>
                </div>
            </div>

        </div>

        <hr class="mt-4 border-light">

        <!-- Copyright -->
        <div class="text-center pt-3">
            <p class="mb-1">&copy; {{ date('Y') }} Cee Horizon. All Rights Reserved.</p>
            <small class="d-block mb-1">Solar • CCTV • Satellite TV • Electrical Works</small>
            <div class="powered-by">
                <small>
                    Powered by: <a href="#" class="footer-link">Yuzcom Web Solutions</a>
                </small>
            </div>
        </div>
    </div>

    <!-- BACK TO TOP BUTTON -->
    <button id="backToTopBtn" class="btn btn-primary position-fixed">
        <i class="bi bi-arrow-up"></i>
    </button>
</footer>

<!-- Back to Top JS -->
<script>
    const backToTopBtn = document.getElementById('backToTopBtn');

    window.onscroll = function () {
        if (document.body.scrollTop > 200 || document.documentElement.scrollTop > 200) {
            backToTopBtn.style.display = "flex";
        } else {
            backToTopBtn.style.display = "none";
        }
    };

    backToTopBtn.addEventListener("click", function () {
        window.scrollTo({ top: 0, behavior: 'smooth' });
    });
</script>
