document.addEventListener('DOMContentLoaded', function () {

    // ===== UNIFIED SECTION REVEAL =====
    const reveals = document.querySelectorAll('.reveal');
    const observer = new IntersectionObserver((entries, obs) => {
        entries.forEach(entry => {
            if(entry.isIntersecting){
                entry.target.classList.add('reveal-active');
                obs.unobserve(entry.target);
            }
        });
    }, { threshold: 0.15 });
    reveals.forEach(el => observer.observe(el));

    // ===== HERO MICRO ANIMATION =====
    const heroTitle = document.querySelector('.hero-title');
    const heroText = document.querySelector('.hero-text');
    const heroActions = document.querySelector('.hero-actions');

    if(heroTitle) heroTitle.style.animation = 'heroFadeUp 0.9s ease-out 0.2s forwards';
    if(heroText) heroText.style.animation = 'heroFadeUp 0.9s ease-out 0.5s forwards';
    if(heroActions) heroActions.style.animation = 'heroFadeUp 0.9s ease-out 0.8s forwards';

});


// public/js/preloader.js
window.addEventListener('load', () => {
    const preloader = document.getElementById('page-preloader');
    if (!preloader) return;

    // Small delay for smoothness
    setTimeout(() => {
        preloader.classList.add('hide');
    }, 300);
});

